﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Fundusz - członkowie</title>
		<script runat="server">

    public class PrnParams : ContextBase {
        public PrnParams(Context context) : base(context) {
            if (context.Contains(typeof(ActualOkres)))
                Okres = ((ActualOkres)context[typeof(ActualOkres)]).Okres;
            else
                Okres = FromTo.Empty;
        }

        FromTo okres;
        [Caption("Za okres")]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = new YearMonth(ActualDate.Today(Context)).ToFromTo();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnParams pars = null;
    [Context(Required = true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    } 		
	                
	FundPożyczkowyWorker worker = new FundPożyczkowyWorker();
	
	void OnContextLoad(object sender, EventArgs args) {
		DefinicjaFunduszuPozyczkowego def = (DefinicjaFunduszuPozyczkowego)dc[typeof(DefinicjaFunduszuPozyczkowego)];
		ReportHeader1["FUNDUSZ"] = def==null ? "?" : def.ToString();
        ReportHeader1["OKRES"] = pars.Okres.ToString();        
	}
		
    void OnBeforeRow(object sender, RowEventArgs args) {
		worker.Fundusz = (FundPozyczkowy)args.Row;        
        if (worker.Fundusz.Okres.From > pars.Okres.To ||
            worker.Fundusz.Okres.To < pars.Okres.From) {
            args.VisibleRow = false;
            return;
        }
        
		Currency wk = worker.Wkład;
		Currency ds = worker.DoSpłaty;
		
		wpład.EditValue = wk;
		pożyczki.EditValue = ds;
		saldo.EditValue = wk - ds;
    }

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="FunduszCzłonkowie" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="%FUNDUSZ% - CZŁONKOWIE|W okresie: %OKRES%" runat="server"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="OnBeforeRow" RowTypeName="Soneta.Kadry.FundPozyczkowy,Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Pracownik.Kod" Caption="Kod" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="35" DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko, Imię" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Okres" Total="Info"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Razem wkład" HideZero="True" Format="{0:n}" ID="wpład"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Pożyczki do spłaty" HideZero="True" Format="{0:n}" ID="pożyczki"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Saldo" Format="{0:n}" ID="saldo"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

